function den_est=alpha_DP_density_est(s,alpha,beta,r2,X,t)
%Implementation of private nonparametric density estimation suggested in Duchi et al(2018)
    n=length(X);
    d=round((n*((exp(alpha)-1)/(exp(alpha)+1))^2*beta*r2*2/pi)^(1/(2*beta+2)));%optimized version
    ortho_coeff=zeros(1,d);
    for i=1:n
        X_new=zeros(1,d);
        for j=1:d
            if mod(j,2)==1
                X_new(j)=sqrt(2)*sin(pi*(j-1)*X(i));
            end
            if mod(j,2)==0
                X_new(j)=sqrt(2)*cos(pi*j*X(i));
            end
            X_new(j)=sqrt(2)*(2*binornd(1,0.5+(X_new(j)/(2*sqrt(2))))-1);
        end
        %rng(s);
        T=binornd(1,exp(alpha)/(1+exp(alpha)));
        if T==1
            Z=hyper_up(s,X_new,alpha);
        end
        if T==0
            Z=hyper_dn(s,X_new,alpha);
        end
        ortho_coeff=ortho_coeff+Z;
    end
    den_est=zeros(1,length(t));
    for k=1:d
        if mod(k,2)==1
            den_est=den_est+ortho_coeff(k)*sqrt(2)*sin(pi*(k-1)*t);
        end
        if mod(k,2)==0
            den_est=den_est+ortho_coeff(k)*sqrt(2)*cos(pi*k*t);
        end
    end
    den_est=ones(1,length(t))+den_est/n;
end